// Expt 6. Circular Convolution using FFT
// O.S. Windows 10
////Scilab 6.0.0
//x1[n]=[1,-1,-2,3,-1]
//x2[n]=[1,2,3]
clear;
clc ;
close ;
x1=[1,-1,-2,3,-1];
x2=[1,2,3];
//Loop for zero padding the smaller sequence out of the two
n1=length(x1);
n2=length(x2);
n3=n2-n1;
if (n3>=0) then
 x1=[x1,zeros(1,n3)];    
else
 x2=[x2,zeros(1,-n3)];
end    
//DFT Computation
X1=fft(x1,-1);
X2=fft(x2,-1);
Y=X1.*X2;
//IDFT Computation
y=fft(Y,1);
n4=length(y);
//Display sequence y[n] in command window
disp(y,"y[n]=");
// Plotting of sequences
t=0:n1-1;
subplot(2,2,1);
plot2d3 (t,x1);
xlabel('n');
ylabel('x1(n)');
title('First sequence x1[n]]');

t1=0:n1-1;
subplot(2,2,2);
plot2d3 (t1,x2);
xlabel('n');
ylabel('x2(n)');
title('Second sequence x2[n]');

t2=0:n1-1;
subplot(2,2,3);
plot2d3 (t1,y);
xlabel('n');
ylabel('y(n)');
title('Circular Convolution of x1[n] & x2[n]');



